/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.entity;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;

public class JKSEntity {
    private KeyStore keystore;
    private char[] password;

    public JKSEntity(String jksFilePath, String jksFilePwd) throws Exception {
        this.keystore = this.initJKSKeyStore(jksFilePath, jksFilePwd);
        this.password = jksFilePwd.toCharArray();
    }

    public JKSEntity(InputStream jksInputStream, String jksFilePwd) throws Exception {
        this.keystore = this.initJKSKeyStore(jksInputStream, jksFilePwd);
        this.password = jksFilePwd.toCharArray();
    }

    public PrivateKey getPrivateKey(String alias) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        return (PrivateKey)this.keystore.getKey(alias, this.password);
    }

    public X509Cert getCert(String alias) throws KeyStoreException, CertificateEncodingException, PKIException {
        Certificate certificate = this.keystore.getCertificate(alias);
        if (certificate != null) {
            return new X509Cert(certificate.getEncoded());
        }
        throw new PKIException("no such alias cert!");
    }

    public KeyStore initJKSKeyStore(String jksFilePath, String jksPWD) throws Exception {
        FileInputStream fin = null;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            fin = new FileInputStream(jksFilePath);
            char[] password = jksPWD.toCharArray();
            ks.load(fin, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new PKIException("load JKS failure", e);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    public KeyStore initJKSKeyStore(InputStream is, String jksPWD) throws Exception {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] password = jksPWD.toCharArray();
            ks.load(is, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new PKIException("load JKS failure", e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

