/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.maker.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.seal.maker.bean.SignInfo;
import cfca.seal.maker.bean.SignResult;
import cfca.seal.maker.bean.UsbKeySeal;
import cfca.seal.maker.util.SealExtracter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WebSealUtil {
    public static SignResult getSignResultFromSeal(byte[] sealSource, String sealPassword, String pfxPassword, byte[] pngData, String signLocation, String signReason) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        byte[] version = new byte[]{2, 0, 1, 0};
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        Date date1899 = simpleDateFormat.parse("1899-12-30 00:00:00");
        long currentTime = (date.getTime() - date1899.getTime()) / 1000L;
        SealExtracter sealExtracter = new SealExtracter(sealSource, pfxPassword);
        UsbKeySeal usbKeySeal = new UsbKeySeal(sealExtracter.getPfxData(), pfxPassword, pngData, sealExtracter.getSignerName(), sealExtracter.getUnitName(), sealExtracter.getSealName());
        SignInfo signInfo = new SignInfo(version, signLocation, signReason, currentTime);
        SignResult signResult = new SignResult(usbKeySeal, signInfo);
        return signResult;
    }

    public static int getKeyStoreType(byte[] keyStoreData) throws PKIException {
        if (keyStoreData == null || keyStoreData.length == 0) {
            throw new PKIException("keyStoreData is null!!!");
        }
        byte[] sm2Oid = new byte[]{42, -127, 28, -49, 85, 6, 1, 4, 2, 1};
        byte[] rsaOid = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 1};
        int rootLength = keyStoreData[1] & 0xF;
        byte seqLength = keyStoreData[6 + rootLength];
        int seqLengthLength = 1;
        if (seqLength < 0) {
            seqLengthLength = seqLengthLength + seqLength & 0xF;
        }
        if (keyStoreData[seqLengthLength + 6 + rootLength] != 6) {
            throw new PKIException("keystore not p12 type!!!");
        }
        byte oidLength = keyStoreData[seqLengthLength + 7 + rootLength];
        int start = seqLengthLength + 8 + rootLength;
        byte[] oidData = new byte[oidLength];
        System.arraycopy(keyStoreData, start, oidData, 0, oidLength);
        if (oidLength == sm2Oid.length && Arrays.areEqual((byte[])oidData, (byte[])sm2Oid)) {
            return 2;
        }
        if (oidLength == rsaOid.length && Arrays.areEqual((byte[])oidData, (byte[])rsaOid)) {
            return 1;
        }
        throw new PKIException("unkown oid !!!");
    }
}

