/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.mapper;

import io.github.autoffice.luckysheet.model.image.SheetImage;
import io.github.autoffice.luckysheet.util.ImageUtil;
import io.github.autoffice.luckysheet.util.NumberUtil;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.util.Units;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMapperToExcel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImageMapperToExcel.class);

    public static void mapToSheet(Map<String, SheetImage> images, XSSFSheet sheet) {
        if (MapUtils.isEmpty(images)) {
            return;
        }
        for (SheetImage image : images.values()) {
            ImageMapperToExcel.mapToSheet(image, sheet);
        }
    }

    private static void mapToSheet(SheetImage image, XSSFSheet sheet) {
        int index = sheet.getWorkbook().addPicture(ImageUtil.getImageData(image), 6);
        ClientAnchor clientAnchor = ImageMapperToExcel.getClientAnchor(image, sheet);
        sheet.createDrawingPatriarch().createPicture(clientAnchor, index);
    }

    private static ClientAnchor getClientAnchor(SheetImage image, XSSFSheet sheet) {
        float rowHeightInPoints;
        float rowHeightInPoints2;
        XSSFCreationHelper creationHelper = sheet.getWorkbook().getCreationHelper();
        ClientAnchor clientAnchor = creationHelper.createClientAnchor();
        int sumRowHeightPixel = 0;
        int i = 0;
        while (true) {
            XSSFRow row;
            rowHeightInPoints2 = (row = sheet.getRow(i)) == null ? sheet.getDefaultRowHeightInPoints() : row.getHeightInPoints();
            if (image.getPosition().getTop() <= (sumRowHeightPixel += Units.pointsToPixel((double)rowHeightInPoints2))) break;
            ++i;
        }
        int row1 = i;
        int dy1 = Units.pointsToPixel((double)rowHeightInPoints2) - (sumRowHeightPixel - image.getPosition().getTop());
        sumRowHeightPixel = 0;
        int i2 = 0;
        while (true) {
            XSSFRow row;
            rowHeightInPoints = (row = sheet.getRow(i2)) == null ? sheet.getDefaultRowHeightInPoints() : row.getHeightInPoints();
            if (image.getPosition().getTop() + image.getPosition().getHeight() <= (sumRowHeightPixel += Units.pointsToPixel((double)rowHeightInPoints))) break;
            ++i2;
        }
        int row2 = i2;
        int dy2 = Units.pointsToPixel((double)rowHeightInPoints) - (sumRowHeightPixel - image.getPosition().getTop() - image.getPosition().getHeight());
        float sumColWidthPixel = 0.0f;
        int i3 = 0;
        while (true) {
            if ((float)image.getPosition().getLeft().intValue() <= (sumColWidthPixel += sheet.getColumnWidthInPixels(i3))) break;
            ++i3;
        }
        int col1 = i3;
        float dx1 = sheet.getColumnWidthInPixels(i3) - (sumColWidthPixel - (float)image.getPosition().getLeft().intValue());
        sumColWidthPixel = 0.0f;
        int i4 = 0;
        while (true) {
            if ((float)(image.getPosition().getLeft() + image.getPosition().getWidth()) <= (sumColWidthPixel += sheet.getColumnWidthInPixels(i4))) break;
            ++i4;
        }
        int col2 = i4;
        float dx2 = sheet.getColumnWidthInPixels(i4) - (sumColWidthPixel - (float)image.getPosition().getLeft().intValue() - (float)image.getPosition().getWidth().intValue());
        clientAnchor.setRow1(row1);
        clientAnchor.setCol1(col1);
        clientAnchor.setRow2(row2);
        clientAnchor.setCol2(col2);
        clientAnchor.setDx1(NumberUtil.pixelToEMU(dx1));
        clientAnchor.setDx2(NumberUtil.pixelToEMU(dx2));
        clientAnchor.setDy1(Units.pixelToEMU((int)dy1));
        clientAnchor.setDy2(Units.pixelToEMU((int)dy2));
        if (image.getType() != null) {
            clientAnchor.setAnchorType(image.getType().getPoiValue());
        }
        return clientAnchor;
    }
}

