/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.cert.assist;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.StringUtil;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.x509.certificate.X509CRL;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrlManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"environmentLogger");
    private static final String DEFAULT_CRL_FILE_NAME = "crl.crl";
    private static Map<String, X509CRL> crlCachePool = new ConcurrentHashMap<String, X509CRL>();

    public static void init(String crlRootDir) throws Exception {
        logger.info("Crl manager init dir({}) start", (Object)crlRootDir);
        if (StringUtil.isEmpty(crlRootDir)) {
            throw new IllegalArgumentException("crlRootDir can not be empty");
        }
        File crlRootDirFile = new File(crlRootDir);
        if (!crlRootDirFile.exists()) {
            throw new CodeException("600802", "the crlRootDir: " + crlRootDir + " is not exist");
        }
        File[] crlDirFileGroup = crlRootDirFile.listFiles();
        if (crlDirFileGroup != null && crlDirFileGroup.length > 0) {
            for (File crlDirFile : crlDirFileGroup) {
                if (!crlDirFile.isDirectory()) continue;
                String crlCacheKey = crlDirFile.getName();
                String crlFilePath = crlRootDir + File.separator + crlCacheKey + File.separator + DEFAULT_CRL_FILE_NAME;
                File crlFile = new File(crlFilePath);
                if (!crlFile.exists()) continue;
                byte[] crlFileData = FileUtils.readFileToByteArray((File)crlFile);
                X509CRL x509CRL = new X509CRL(crlFileData);
                crlCachePool.put(crlCacheKey, x509CRL);
                logger.info("Crl manager add crl(key:{})", (Object)crlCacheKey);
            }
        }
        SysEnv.loadCRL((String)crlRootDir);
        logger.info("Crl manager init dir({}) successfully\n", (Object)crlRootDir);
    }

    public static X509CRL getX509CRL(String issuerKey) {
        return crlCachePool.get(issuerKey);
    }
}

