/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf;

import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfIndirectReference;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfNumber;
import cfca.com.itextpdf.text.pdf.PdfObject;
import cfca.com.itextpdf.text.pdf.PdfRectangle;
import java.awt.Color;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfPage
extends PdfDictionary {
    private static final String[] boxStrings = new String[]{"crop", "trim", "art", "bleed"};
    private static final PdfName[] boxNames = new PdfName[]{PdfName.CROPBOX, PdfName.TRIMBOX, PdfName.ARTBOX, PdfName.BLEEDBOX};
    public static final PdfNumber PORTRAIT = new PdfNumber(0);
    public static final PdfNumber LANDSCAPE = new PdfNumber(90);
    public static final PdfNumber INVERTEDPORTRAIT = new PdfNumber(180);
    public static final PdfNumber SEASCAPE = new PdfNumber(270);
    PdfRectangle mediaBox;
    private static final Color TRANSPARENT_WHITE = new Color(255, 255, 255, 0);

    public PdfPage(PdfRectangle mediaBox, HashMap<String, PdfRectangle> boxSize, PdfDictionary resources, int rotate) throws DocumentException {
        super(PAGE);
        this.mediaBox = mediaBox;
        if (mediaBox != null && (mediaBox.width() > 14400.0f || mediaBox.height() > 14400.0f)) {
            throw new DocumentException(MessageLocalization.getComposedMessage("the.page.size.must.be.smaller.than.14400.by.14400.its.1.by.2", Float.valueOf(mediaBox.width()), Float.valueOf(mediaBox.height())));
        }
        this.put(PdfName.MEDIABOX, mediaBox);
        this.put(PdfName.RESOURCES, resources);
        if (rotate != 0) {
            this.put(PdfName.ROTATE, new PdfNumber(rotate));
        }
        for (int k = 0; k < boxStrings.length; ++k) {
            PdfObject rect = boxSize.get(boxStrings[k]);
            if (rect == null) continue;
            this.put(boxNames[k], rect);
        }
    }

    public PdfDictionary findResources() {
        PdfDictionary resources = (PdfDictionary)this.get(PdfName.RESOURCES);
        return resources;
    }

    public PdfIndirectReference getContents() {
        PdfIndirectReference contents = (PdfIndirectReference)this.get(PdfName.CONTENTS);
        return contents;
    }

    public PdfPage(PdfRectangle mediaBox, HashMap<String, PdfRectangle> boxSize, PdfDictionary resources) throws DocumentException {
        this(mediaBox, boxSize, resources, 0);
    }

    public boolean isParent() {
        return false;
    }

    public void add(PdfIndirectReference contents) {
        this.put(PdfName.CONTENTS, contents);
    }

    PdfRectangle rotateMediaBox() {
        this.mediaBox = this.mediaBox.rotate();
        this.put(PdfName.MEDIABOX, this.mediaBox);
        return this.mediaBox;
    }

    public int findRotation() throws DocumentException {
        PdfNumber rotateNumber = (PdfNumber)this.get(PdfName.ROTATE);
        if (rotateNumber == null) {
            throw new DocumentException("parameter rotate not found in page!");
        }
        int rotate = rotateNumber.intValue();
        return rotate;
    }

    public PdfRectangle findCropBox() throws DocumentException {
        PdfRectangle cropBox = (PdfRectangle)this.get(PdfName.CROPBOX);
        if (cropBox == null) {
            throw new DocumentException("parameter cropbox not found in page! ");
        }
        return cropBox;
    }

    PdfRectangle getMediaBox() {
        return this.mediaBox;
    }
}

